/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.message;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.toolkit.designer.message.VWSIMValidationErrorListCellRenderer;
import filenet.sim.toolkit.designer.message.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.images.VWImageLoader;
import filenet.vw.toolkit.design.message.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModelessDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class VWSIMScenarioValidationResultsDialog
extends VWModelessDialog
implements IVWFrameInterface,
ActionListener {
    private static final int WINDOW_WIDTH = 450;
    private static final int WINDOW_HEIGHT = 400;
    private JLabel m_errorCountLabel = null;
    private JLabel m_warningCountLabel = null;
    private JComboBox m_errorComboBox = null;
    private JLabel m_levelLabel = null;
    private JLabel m_typeLabel = null;
    private JLabel m_displayingLabel = null;
    private JButton m_upButton = null;
    private JButton m_downButton = null;
    private JTextArea m_messageTextArea = null;
    private JTextArea m_informationTextArea = null;
    private JButton m_revalidateButton = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private VWSIMPropertyData m_propertyData = null;
    private Integer m_nErrorCount = null;

    public VWSIMScenarioValidationResultsDialog(VWSIMPropertyData propertyData) {
        super(propertyData.getParentFrame(), propertyData.getSessionInfo());
        this.m_propertyData = propertyData;
        this.setTitle(VWSIMResource.s_scenarioValidationResultsWindowTitle);
        if (!this.updateWindowPosition("validation_results_location", "validation_results_size")) {
            Dimension dim = VWStringUtils.stringToDimension("495, 445");
            if (dim == null) {
                this.updateWindowPosition(450, 400, 0);
            } else {
                this.updateWindowPosition(dim.width, dim.height, 0);
            }
        }
        this.createControls();
        this.addWindowListener(new VWWindowAdapter(this));
    }

    public void setVisible(boolean bShow) {
        boolean bWasVisible = this.isVisible();
        if (bWasVisible && !bShow) {
            this.saveWindowPosition("validation_results_location", "validation_results_size");
        }
        super.setVisible(bShow);
    }

    public void windowClosing(WindowEvent event) {
        this.performExitItemAction(false);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_errorComboBox)) {
            this.handleComboBoxSelection();
        } else if (source.equals(this.m_upButton)) {
            this.handleUpButtonClick();
        } else if (source.equals(this.m_downButton)) {
            this.handleDownButtonClick();
        } else if (source.equals(this.m_revalidateButton)) {
            this.m_propertyData.getToolbarActionNotifier().notifyToolbarAction(this, 652);
        } else if (source.equals(this.m_closeButton)) {
            this.setVisible(false);
        } else if (source.equals(this.m_helpButton)) {
            VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Designer + "scenariovalidationresultsdialog.htm");
        }
    }

    protected boolean validateScenario(VWScenarioDefinition scenarioDef, boolean bDisplayMessage, boolean bValidateWorkflows) {
        boolean bValid = false;
        try {
            VWScenarioValidationError[] errors = scenarioDef.validate(this.m_propertyData.getSessionInfo().getSession(), bValidateWorkflows, this.m_propertyData.getSystemConfiguration(), this.m_propertyData.getSdfFileContents());
            if (errors == null) {
                this.setVisible(false);
                if (bDisplayMessage) {
                    VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_validScenarioMessage, 2);
                }
                bValid = true;
            } else {
                int nWarningCount = 0;
                int nErrorCount = 0;
                block6: for (int i = 0; i < errors.length; ++i) {
                    switch (errors[i].getLevel()) {
                        case 2: {
                            ++nWarningCount;
                            continue block6;
                        }
                        case 1: {
                            ++nErrorCount;
                        }
                    }
                }
                if (nErrorCount > 0 && nWarningCount > 0) {
                    bValid = false;
                } else if (nErrorCount > 0) {
                    bValid = false;
                } else if (nWarningCount > 0) {
                    bValid = true;
                }
                if (!bValid || bValid && bDisplayMessage) {
                    this.displayValidationMessages(errors);
                    this.setVisible(true);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
            return false;
        }
        return bValid;
    }

    protected void displayValidationMessages(VWScenarioValidationError[] errors) {
        DefaultComboBoxModel<VWScenarioValidationError> cbModel = new DefaultComboBoxModel<VWScenarioValidationError>(errors);
        this.m_errorComboBox.setModel(cbModel);
        int nErrorCount = 0;
        int nWarningCount = 0;
        this.m_nErrorCount = new Integer(0);
        if (errors != null) {
            this.m_nErrorCount = new Integer(errors.length);
            block4: for (int i = 0; i < errors.length; ++i) {
                switch (errors[i].getLevel()) {
                    case 1: {
                        ++nErrorCount;
                        continue block4;
                    }
                    case 2: {
                        ++nWarningCount;
                    }
                }
            }
        }
        this.m_errorCountLabel.setText(Integer.toString(nErrorCount));
        this.m_warningCountLabel.setText(Integer.toString(nWarningCount));
        if (cbModel.getSize() > 0) {
            this.m_errorComboBox.setSelectedIndex(0);
        }
        this.setVisible(true);
    }

    private void createControls() {
        this.getContentPane().setLayout(new BorderLayout(4, 4));
        JPanel panel = this.createTopPanel();
        if (panel != null) {
            this.getContentPane().add((Component)panel, "First");
        }
        if ((panel = this.createMainPanel()) != null) {
            this.getContentPane().add((Component)panel, "Center");
        }
        if ((panel = this.createButtonPanel()) != null) {
            this.getContentPane().add((Component)panel, "Last");
        }
        super.updateComponentOrientation();
    }

    private JPanel createTopPanel() {
        try {
            JPanel topPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            topPanel.add((Component)new JLabel(VWResource.s_numberOfErrors), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_errorCountLabel = new JLabel("0");
            topPanel.add((Component)this.m_errorCountLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            topPanel.add((Component)new JLabel(VWResource.s_numberOfWarnings), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_warningCountLabel = new JLabel("0");
            topPanel.add((Component)this.m_warningCountLabel, gbCons);
            return topPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            mainPanel.add((Component)this.createPanelOne(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            mainPanel.add((Component)this.createPanelTwo(), gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            mainPanel.add((Component)this.createPanelThree(), gbCons);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createPanelOne() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)new JLabel(VWResource.s_nameColon), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_errorComboBox = new JComboBox();
            this.m_errorComboBox.setRenderer(new VWSIMValidationErrorListCellRenderer());
            this.m_errorComboBox.addActionListener(this);
            panel.add((Component)this.m_errorComboBox, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_level)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_levelLabel = new JLabel();
            panel.add((Component)this.m_levelLabel, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_type)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_typeLabel = new JLabel();
            panel.add((Component)this.m_typeLabel, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_displaying)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_displayingLabel = new JLabel();
            panel.add((Component)this.m_displayingLabel, gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createPanelTwo() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 19;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_upButton = VWImageLoader.createIconButton("up.gif", VWResource.s_up);
            this.m_upButton.addActionListener(this);
            buttonPanel.add((Component)this.m_upButton, gbCons);
            ++gbCons.gridy;
            this.m_downButton = VWImageLoader.createIconButton("down.gif", VWResource.s_down);
            this.m_downButton.addActionListener(this);
            buttonPanel.add((Component)this.m_downButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createPanelThree() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_message)), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.7;
            this.m_messageTextArea = new JTextArea();
            this.m_messageTextArea.setLineWrap(true);
            this.m_messageTextArea.setWrapStyleWord(true);
            this.m_messageTextArea.setEditable(false);
            panel.add((Component)new JScrollPane(this.m_messageTextArea), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_information)), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.3;
            this.m_informationTextArea = new JTextArea();
            this.m_informationTextArea.setLineWrap(true);
            this.m_informationTextArea.setWrapStyleWord(true);
            this.m_informationTextArea.setEditable(false);
            panel.add((Component)new JScrollPane(this.m_informationTextArea), gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_revalidateButton = new JButton(VWResource.s_revalidate);
            this.m_revalidateButton.addActionListener(this);
            buttonPanel.add((Component)this.m_revalidateButton, gbCons);
            ++gbCons.gridx;
            this.m_closeButton = new JButton(VWResource.s_close);
            this.m_closeButton.addActionListener(this);
            buttonPanel.add((Component)this.m_closeButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void handleComboBoxSelection() {
        VWScenarioValidationError error = (VWScenarioValidationError)this.m_errorComboBox.getSelectedItem();
        if (error != null) {
            String tmpStr = null;
            switch (error.getLevel()) {
                case 1: {
                    tmpStr = VWResource.s_error;
                    break;
                }
                case 2: {
                    tmpStr = VWResource.s_warning;
                }
            }
            this.m_levelLabel.setText(tmpStr);
            switch (error.getErrorType()) {
                case 2: {
                    tmpStr = VWSIMResource.s_scenario;
                    break;
                }
                case 7: {
                    tmpStr = VWSIMResource.s_arrival;
                    break;
                }
                case 3: {
                    tmpStr = VWSIMResource.s_resource;
                    break;
                }
                case 4: {
                    tmpStr = VWSIMResource.s_role;
                    break;
                }
                case 5: {
                    tmpStr = VWSIMResource.s_shift;
                    break;
                }
                case 8: {
                    tmpStr = VWSIMResource.s_step;
                    break;
                }
                case 6: {
                    tmpStr = VWSIMResource.s_scenarioWorkflow;
                    break;
                }
                case 1: {
                    tmpStr = VWSIMResource.s_workflow;
                }
            }
            this.m_typeLabel.setText(tmpStr);
            int nIndex = this.m_errorComboBox.getSelectedIndex() + 1;
            this.m_displayingLabel.setText(VWResource.s_nofm.toString(new Integer(nIndex), this.m_nErrorCount));
            this.m_messageTextArea.setText(error.getMessage());
            this.m_informationTextArea.setText(error.getInfo());
        }
        this.updateButtonState();
    }

    private void handleUpButtonClick() {
        int nIndex = this.m_errorComboBox.getSelectedIndex();
        this.m_errorComboBox.setSelectedIndex(nIndex - 1);
        this.updateButtonState();
    }

    private void handleDownButtonClick() {
        int nIndex = this.m_errorComboBox.getSelectedIndex();
        this.m_errorComboBox.setSelectedIndex(nIndex + 1);
        this.updateButtonState();
    }

    private void updateButtonState() {
        int nIndex = this.m_errorComboBox.getSelectedIndex();
        if (nIndex == 0) {
            this.m_upButton.setEnabled(false);
        } else {
            this.m_upButton.setEnabled(true);
        }
        if (nIndex == this.m_errorComboBox.getModel().getSize() - 1) {
            this.m_downButton.setEnabled(false);
        } else {
            this.m_downButton.setEnabled(true);
        }
    }

    private void performExitItemAction(boolean bCloseWindow) {
        if (bCloseWindow) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
        }
    }
}

